CREATE OR REPLACE FUNCTION public.ufd_est_prod_tbl_desc_pre_vencidos2(
      integer,
      integer,
      character varying )
   RETURNS SETOF rs_temp_return_rec AS
$BODY$
DECLARE
   in_cd_emp         ALIAS for $1;
   in_cd_filial      ALIAS for $2;
   in_ean_pre_venc   ALIAS for $3;
   --var_1           double precision;
BEGIN

	BEGIN
		CREATE TEMPORARY TABLE temp_tab_desc
		(   
			cd_emp int,
         cd_filial int,
         cd_prod int,
         cd_tbl_desc int
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_tab_desc; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.	
	END;

	BEGIN
		CREATE TEMPORARY TABLE temp_tab_nivel_desc
		(   
			cd_emp int,
         cd_filial int,
         cd_prod int,
         cd_tbl_desc int,
         perc_desc double precision,
         perc_desc_max double precision,
         tp_nivel int
		);
		EXCEPTION WHEN OTHERS THEN
		TRUNCATE TABLE temp_tab_nivel_desc; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.	
	END;


   ---- localiza tabela desconto pre vencido

   insert into temp_tab_desc
   select a.cd_emp , a.cd_filial , a.cd_prod , d.cd_tbl_desc
      --select *
      from est_prod_cpl_lote a
      join est_prod_rem_pre_venc_it_lote b 
         on a.cd_emp	 = b.cd_emp 
         and a.cd_filial = b.cd_filial 
         and a.cd_lote	 = b.cd_lote  
      join est_prod_tbl_desc   d
         on d.cd_emp  = b.cd_emp
         and d.sts_tbl_desc = 1
         and d.cd_tp_desconto = 26
      join est_prod_tbl_desc_prc_filial  df
         on df.cd_emp  = a.cd_emp
         and df.cd_filial = a.cd_filial
         and df.cd_tbl_desc = d.cd_tbl_desc
      where a.cd_emp = in_cd_emp
         and a.cd_filial = in_cd_filial
         and b.ean = in_ean_pre_venc
         and ( a.dt_valid::date - current_date::date ) ::numeric  between d.dias_ini and d.dias_fim
         and current_date between date(d.dt_ini) and date(d.dt_fim);


   ---- nivel 1 - produto

   insert into temp_tab_nivel_desc
   select t.cd_emp , t.cd_filial , t.cd_prod , t.cd_tbl_desc , dp.perc_desc , dp.perc_desc_max , 1 as tp_nivel --, 'PRODUTO' as nivel
      from temp_tab_desc   t
      join est_prod_tbl_desc_est_prod  dp
         on dp.cd_emp  = t.cd_emp
         and dp.cd_tbl_desc = t.cd_tbl_desc
         and dp.cd_prod = t.cd_prod;


   ---- nivel 2 - familia

   insert into temp_tab_nivel_desc
   select t.cd_emp , t.cd_filial , t.cd_prod , t.cd_tbl_desc , df.perc_desc , df.perc_desc_max , 2 as tp_nivel --, 'FAMILIA' as nivel
      from temp_tab_desc   t
      join est_prod_est_arv_mercadologica   a
         on a.cd_emp  = t.cd_emp
         and a.cd_prod = t.cd_prod
      join est_prod_tbl_desc_est_arv_merc_familia  df
         on df.cd_emp  = t.cd_emp
         and df.cd_tbl_desc = t.cd_tbl_desc
         and df.cd_arv_merc_familia = a.cd_arv_merc_familia
      where not exists
            ( select 1
                  from temp_tab_nivel_desc x
                  where x.cd_emp = t.cd_emp
                     and x.cd_filial = t.cd_filial
                     and x.cd_prod = t.cd_prod
                     and x.cd_tbl_desc = t.cd_tbl_desc );



   ---- nivel 3 - marca

   insert into temp_tab_nivel_desc
   select t.cd_emp , t.cd_filial , t.cd_prod , t.cd_tbl_desc , dm.perc_desc , dm.perc_desc_max , 3 as tp_nivel --, 'MARCA' as nivel
      from temp_tab_desc   t
      join est_prod_est_arv_mercadologica   a
         on a.cd_emp  = t.cd_emp
         and a.cd_prod = t.cd_prod
      join est_prod_tbl_desc_est_mc  dm
         on dm.cd_emp  = t.cd_emp
         and dm.cd_tbl_desc = t.cd_tbl_desc
         and dm.cd_mc = a.cd_mc
      where not exists
            ( select 1
                  from temp_tab_nivel_desc x
                  where x.cd_emp = t.cd_emp
                     and x.cd_filial = t.cd_filial
                     and x.cd_prod = t.cd_prod
                     and x.cd_tbl_desc = t.cd_tbl_desc );


   ---- nivel 4 - fabricante

   insert into temp_tab_nivel_desc
   select t.cd_emp , t.cd_filial , t.cd_prod , t.cd_tbl_desc , dfa.perc_desc , dfa.perc_desc_max , 4 as tp_nivel --, 'FABRICANTE' as nivel
      from temp_tab_desc   t
      join est_prod  p
         on p.cd_emp  = t.cd_emp
         and p.cd_prod = t.cd_prod
      join est_prod_est_arv_mercadologica   a
         on a.cd_emp  = t.cd_emp
         and a.cd_prod = t.cd_prod
      join est_prod_tbl_desc_est_prod_fabric  dfa
         on dfa.cd_emp  = t.cd_emp
         and dfa.cd_tbl_desc = t.cd_tbl_desc
         and dfa.cd_fabric = p.cd_fabric
      where not exists
            ( select 1
                  from temp_tab_nivel_desc x
                  where x.cd_emp = t.cd_emp
                     and x.cd_filial = t.cd_filial
                     and x.cd_prod = t.cd_prod
                     and x.cd_tbl_desc = t.cd_tbl_desc );


   ---- nivel 5 - categoria

   insert into temp_tab_nivel_desc
   select t.cd_emp , t.cd_filial , t.cd_prod , t.cd_tbl_desc , dc.perc_desc , dc.perc_desc_max , 5 as tp_nivel --, 'CATEGORIA' as nivel
      from temp_tab_desc   t
      join est_prod_est_arv_mercadologica   a
         on a.cd_emp  = t.cd_emp
         and a.cd_prod = t.cd_prod
      join est_prod_tbl_desc_est_arv_merc_categoria  dc
         on dc.cd_emp  = t.cd_emp
         and dc.cd_tbl_desc = t.cd_tbl_desc
         and dc.cd_arv_merc_categ = a.cd_arv_merc_categ
      where not exists
         ( select 1
               from temp_tab_nivel_desc x
               where x.cd_emp = t.cd_emp
                  and x.cd_filial = t.cd_filial
                  and x.cd_prod = t.cd_prod
                  and x.cd_tbl_desc = t.cd_tbl_desc );


   ---- nivel 6 - linha

   insert into temp_tab_nivel_desc
   select t.cd_emp , t.cd_filial , t.cd_prod , t.cd_tbl_desc , dl.perc_desc , dl.perc_desc_max , 6 as tp_nivel --, 'LINHA' as nivel
      from temp_tab_desc   t
      join est_prod_est_arv_mercadologica   a
         on a.cd_emp  = t.cd_emp
         and a.cd_prod = t.cd_prod
      join est_prod_tbl_desc_est_arv_merc_linha  dl
         on dl.cd_emp  = t.cd_emp
         and dl.cd_tbl_desc = t.cd_tbl_desc
         and dl.cd_arv_merc_linha = a.cd_arv_merc_linha
      where not exists
            ( select 1
                  from temp_tab_nivel_desc x
                  where x.cd_emp = t.cd_emp
                     and x.cd_filial = t.cd_filial
                     and x.cd_prod = t.cd_prod
                     and x.cd_tbl_desc = t.cd_tbl_desc );



   ----- retorno do melhor desconto entre os niveis

   return QUERY 
      select d.cd_tbl_desc , d.perc_desc , d.perc_desc_max , d.tp_nivel
         from temp_tab_nivel_desc  d
         join 
            (
               select MAX( perc_desc ) as perc_desc
               from temp_tab_nivel_desc
            )  md
            on md.perc_desc = d.perc_desc
         join
            (
               select perc_desc , MIN( tp_nivel ) as tp_nivel
               from temp_tab_nivel_desc
               group by perc_desc
            ) mn
            on mn.perc_desc = md.perc_desc
            and mn.tp_nivel = d.tp_nivel;



END;

-- fim bloco principal
$BODY$
  LANGUAGE plpgsql VOLATILE
  COST 10
  ROWS 1000;
ALTER FUNCTION public.ufd_est_prod_tbl_desc_pre_vencidos2(
      integer,
      integer,
      character varying )
  OWNER TO postgres;


